/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBUtils				= Object.create(STBModule.prototype);
	STBUtils.name			= "Utils";
	STBUtils.scripts		= [];

STBUtils.isBrowserFrozen =function() {
	return jQuery("body").hasClass("frozen");
}

STBUtils.freezeBrowser = function() {
	if (site.onepage) {
		return false;
	}

	var pos = jQuery(window).scrollTop();

	if (jQuery("body").hasClass("sticky")){
		jQuery("body").addClass("had-sticky");
	}

	jQuery("body").addClass("frozen").attr("data-scrolled", pos);
	jQuery("body").css("top", -pos);
	jQuery("body").css("left", 0);

	if (jQuery("body").hasClass("had-sticky")) {
		var	
			header			= jQuery('.header'),
			mainNav			= jQuery(".main-nav");

		if (mainNav.attr("data-bgs") != ""){
			mainNav.removeClass(mainNav.attr("data-bg")).addClass(mainNav.attr("data-bgs"));
			header.removeClass(header.attr("data-bg")).addClass(header.attr("data-bgs"));
		}
	}
}


STBUtils.unfreezeBrowser = function() {
	if (site.onepage) {
		return false;
	}


	if (jQuery("body").hasClass("had-sticky")) {

		var	
			header			= jQuery('.header'),
			mainNav			= jQuery(".main-nav");

		//add the bgclass if exists
		if (mainNav.attr("data-bg") != ""){
			mainNav.removeClass(mainNav.attr("data-bgs")).addClass(mainNav.attr("data-bg"));
			header.removeClass(header.attr("data-bgs")).addClass(header.attr("data-bg"));
		}

		jQuery("body").removeClass("had-sticky");
	}

	jQuery("body").removeClass("frozen");
	jQuery("body").css("top", 0);

	jQuery(window).scrollTop(jQuery("body").attr("data-scrolled"));

	if (jQuery("body").hasClass("top-menu")){
		jQuery("header").css("top", 0);
	}
}



STBUtils.momentConvertLocale = function(code) {
    try {
        var loc = {
            "ab": "",
            "aa": "",
            "af": "af",
            "sq": "sq",
            "am": "",
            "ar": "ar",
            "hy": "hy-am",
            "as": "",
            "ay": "",
            "az": "az",
            "ba": "",
            "eu": "eu",
            "bn": "bn",
            "dz": "",
            "bh": "",
            "bi": "",
            "br": "br",
            "bg": "bg",
            "my": "my",
            "be": "be",
            "km": "km",
            "ca": "ca",
            "zh": "zh-cn",
            "co": "",
            "hr": "hr",
            "cs": "cs",
            "da": "da",
            "nl": "nl",
            "en": "en_gb",
            "gb": "en_gb",
            "eo": "eo",
            "et": "et",
            "fo": "fo",
            "fj": "",
            "fi": "fi",
            "fr": "fr",
            "fy": "fy",
            "gd": "gd",
            "gl": "gl",
            "ka": "ka",
            "de": "de",
            "el": "el",
            "kl": "",
            "gn": "",
            "gu": "",
            "ha": "",
            "iw": "he",
            "he": "he",
            "hi": "hi",
            "hu": "hu",
            "is": "is",
            "in": "id",
            "ia": "",
            "ie": "",
            "ik": "",
            "ga": "",
            "it": "it",
            "ja": "ja",
            "jw": "jv",
            "kn": "",
            "ks": "",
            "kk": "kk",
            "rw": "",
            "ky": "ky",
            "rn": "",
            "ko": "ko",
            "ku": "",
            "lo": "lo",
            "la": "",
            "lv": "lv",
            "ln": "",
            "lt": "lt",
            "mk": "mk",
            "mg": "",
            "ms": "ms",
            "ml": "ml",
            "mt": "",
            "mi": "mi",
            "mr": "mr",
            "mo": "ro",
            "mn": "",
            "na": "",
            "ne": "ne",
            "no": "nb",
            "oc": "",
            "or": "",
            "om": "",
            "ps": "",
            "fa": "fa",
            "pl": "pl",
            "pt": "pt",
            "pa": "pa-in",
            "qu": "",
            "rm": "",
            "ro": "ro",
            "ru": "ru",
            "sm": "",
            "sg": "",
            "sa": "",
            "sr": "sr",
            "sh": "hr",
            "st": "",
            "tn": "",
            "sn": "",
            "sd": "",
            "si": "si",
            "ss": "ss",
            "sk": "sk",
            "sl": "sl",
            "so": "",
            "es": "es",
            "su": "",
            "sw": "sw",
            "sv": "sv",
            "tl": "tl-ph",
            "tg": "",
            "ta": "ta",
            "tt": "",
            "te": "te",
            "th": "th",
            "bo": "bo",
            "ti": "",
            "to": "",
            "ts": "",
            "tr": "tr",
            "tk": "",
            "tw": "",
            "uk": "uk",
            "ur": "",
            "uz": "uz",
            "vi": "vi",
            "vo": "",
            "cy": "cy",
            "wo": "",
            "xh": "",
            "ji": "",
            "yo": "",
            "zu": ""
        }, i, c;

        for (i in loc) {
            if (i == code) {

                if (loc[i]) {
                    c = loc[i];
                } else {
                    c = "en_gb";
                }

                return c;
            }
        }

    } catch (e) {
        getStack(0, e);
    }
}



STBUtils.bootstrapCols = function(items) {
    try {
        switch (items) {
            case "12":
                items = 1;
                break;
            case "6":
                items = 2;
                break;
            case "4":
                items = 3;
                break;
            case "3":
                items = 4;
                break;

            case "1-5":
                items = 5;
				break;

			case "2":
                items = 6;
                break;

            case "1-7":
                items = 7;
	            break;

            case "1":
                items = 12;
                break;
        }

        return items;

    } catch (e) {
        getStack(0, e);
    }
}



STBUtils.str_replace = function( r, w , s){
     return s.split(r).join(w);
}


STBUtils.isInView = function(elem) {
    var docViewTop = jQuery(window).scrollTop();
    var docViewBottom = docViewTop + jQuery(window).height();

    var elemTop = elem.offset().top;
    var elemBottom = elemTop + elem.height();

    return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
}


STBUtils.bgSchemeReplace = function(string, rep){
	try{
		var str_find = '{BG:SCHEME}';

		return string.replace( 
			new RegExp(str_find, "gi"), 
			rep 
		) ;      
	} catch(ex){
		return string;
	}
}


STBUtils.attrDefaultValue = function(data, def) {
    try {
        var res;

        if (typeof data === "undefined") {
            res = def;
        } else {

			if (data == ""){
				return def;
			} else {
	            res = data;
			}
        }

        return res;

    } catch (e) {
        getStack(0, e);
    }
}


STBUtils.loadScriptCallback = function(path , callback , execute) {

	//controls if the callback is executed everytime or only once when the script is loaded
	execute = execute || true;
	
	if (jQuery.inArray(path , STBUtils.scripts) === -1) {
		STBUtils.scripts.push(path);

		jQuery.getScript(
			path,
			function() {
				if (callback) {
					callback();
				}
			}
		);
	} else {

		if (execute && callback) {
			callback();
		}
	}
}


//custom add/remove css class
jQuery.fn.extend({
	addUserClass: function(uclass) {
	  if (!jQuery(this).hasClass(uclass)) {
		  jQuery(this).addClass(uclass);
	  }
	},

	removeUserClass: function(uclass) {
	  if (jQuery(this).hasClass(uclass)) {
		  jQuery(this).removeClass(uclass);
	  }
	},

	hasAnyOfClasses: function(uclass) {

		var items = uclass.split(",");

		console.log("test");
		console.log(items);

		if (items.length > 0) {
			jQuery().each(items , function(index, value) {
				console.log(value);
				if (jQuery(this).hasClass(uclass)) {
					return true;
				}
			});
		}

		return false;
	}

});

function goBack() {
    window.history.back();
}

function scrollToClass(data) {

	var el = jQuery("." + data );

	if (el.length > 0) {
		var loc = el.offset();

		if (jQuery(".page-wrapper").length) {
			var cont = jQuery(".page-wrapper");
		} else {
			var cont = jQuery("html, body");
		}

		cont.stop().animate(
			{
				scrollTop: ( loc.top)
			}
		);
	}
}